#include "random_coord.h"
#include "galaxy_types.h"
#include <stdlib.h>
#include <math.h>

gal_system *alloc_gal_system(int nb_element, double typical_length,
		double radius_max, double total_mass, double step, double duration) {
	gal_system *sys;
	int dim = 3;

	sys = malloc(sizeof(gal_system));
	
	sys->dimension = dim;
	sys->nb_element = nb_element;
	sys->typical_length = typical_length;
	sys->radius_max = radius_max;
	sys->total_mass = total_mass;
	sys->mass_element = total_mass / (double) nb_element;

	sys->duration = duration;
	sys->stepsize = step;
	sys->nbstep = (int) (sys->duration/sys->stepsize + 1);

	sys->vel = malloc(dim*nb_element*sizeof(double));
	sys->pos = malloc(dim*nb_element*sizeof(double));
	sys->mass = malloc(nb_element*sizeof(double));

	int planet;
	double pos_norm, phi, theta, vel_norm;
	for(planet=0; planet<nb_element; planet++) {
		pos_norm = compute_random_radius(sys);
		phi = compute_random_phi();
		theta = compute_random_theta();

		sys->pos[planet*dim+X] = pos_norm * sin(theta) * cos(phi);
		sys->pos[planet*dim+Y] = pos_norm * sin(theta) * sin(phi);
		sys->pos[planet*dim+Z] = pos_norm * cos(theta);

		vel_norm = compute_random_velocity_norm(sys,pos_norm);
		phi = compute_random_phi();
		theta = compute_random_theta();
		
		sys->vel[planet*dim+X] = vel_norm * sin(theta) * cos(phi);
		sys->vel[planet*dim+Y] = vel_norm * sin(theta) * sin(phi);
		sys->vel[planet*dim+Z] = vel_norm * cos(theta);

		sys->mass[planet] = sys->mass_element;
	}
	
	return sys;
}

void free_gal_system(gal_system *sys) {
	free(sys->pos);
	free(sys->vel);
	free(sys);
}
