#ifndef GALAXY_TYPES
#define GALAXY_TYPES

enum coord_name {X,Y,Z};

typedef struct {
	double typical_length;
	double radius_max;
	double mass_element;
	double total_mass;
	int nb_element;
	int dimension;

	double duration;
	double stepsize;
	int nbstep;

	char *output_name;

	double* vel;
	double* pos;
	double* mass;
} gal_system;

gal_system *alloc_gal_system(int nb_element, double typical_length, double radius_max, double total_mass, double step, double duration);
void free_gal_system(gal_system *sys); 

#endif
