#include "galaxy_types.h"
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void print_usage(void) {
	printf(	"Usage:"
		"	-p --nbparticles	Set the number of particles in the .ini file (default: 512)"
		"	-o --output		Set the name of the .ini file"
		"	-h --help		Print this screen");
}

int main (int argc, char* argv[]) {
	int nb_element = 512;

        double typical_length = 1.0e18;
        double radius_max = 8*typical_length;
        double total_mass = 1.9891e39;

        int nb_step = 1000;
        double duration = 1000;
        double step = duration / nb_step;

        char *output_name= strdup("galaxy.ini");

	int i=1;
	while(i<argc) {
		if(!strcmp("-p",argv[i]) ||
		   !strcmp("--nbparticles",argv[i])) {
		   	nb_element = strtod(argv[++i],NULL);
			i++;
			continue;
		}
		if(!strcmp("-o",argv[i]) ||
		   !strcmp("--output",argv[i])) {
		   	free(output_name);
		   	output_name = strdup(argv[++i]);
			i++;
			continue;
		}
		if(!strcmp("-h",argv[i]) ||
		   !strcmp("--help",argv[i])) {
		   	print_usage();
			return 0;
		}
		i++;
	}

        gal_system *sys = alloc_gal_system(nb_element, typical_length,
                        radius_max, total_mass, step, duration);

	FILE* fpout = NULL;
	fpout = fopen(output_name, "w");
	if(fpout == NULL) {
		printf("erreur: fopen cannot open %s", output_name);
		return 1;
	}
	int j;
	for(i=0; i<nb_element; i++) {
		fprintf(fpout, "[element%d]\n",i);
		fprintf(fpout, "mass = %lf\n", total_mass/nb_element);
		for(j=0; j<3; j++)
			fprintf(fpout, "x_%d = %lf\n", j, sys->pos[i*3+j]);
		for(j=0; j<3; j++)
			fprintf(fpout, "v_%d = %lf\n", j, sys->vel[i*3+j]);
		fprintf(fpout,"\n");
	}
	fclose(fpout);
	return 0;
}
