#include <math.h>
#include <stdio.h>
#include "novas.h"
#include "solarsystem.h"
#include "eph_manager.h"

#define PI (3.141592653589793)

int main(int argc, char* argv[]) {
	//Definition of physical quantities
	char* planets_names[9] = 	{"Sun"
					,"Mercury"
					,"Venus"
					,"Earth"
					,"Mars"
					,"Jupiter"
					,"Saturne"
					,"Uranus"
					,"Neptune"};
	double planets_masses[9] = 	{1.9891*pow(10,30)
					,330.20*pow(10,21)
					,4.8685*pow(10,24)
					,5.9736*pow(10,24)
					,641.85*pow(10,21)
					,1.8986*pow(10,27)
					,568.46*pow(10,24)
					,86.810*pow(10,24)
					,102.43*pow(10,24)};
	double planets_positions_ecliptic[9][3];
	double planets_velocities_ecliptic[9][3];

	double planets_positions_equatorial[9][3];
	double planets_velocities_equatorial[9][3];

	
	// Computation of the Julian Date
	int i;
	short int year, month, day;
	double hour;
	if(argc==5) {
		if(sscanf(argv[1],"%hd",&year)!=1
		|| sscanf(argv[2],"%hd",&month)!=1
		|| sscanf(argv[3],"%hd",&day)!=1
		|| sscanf(argv[4],"%lf",&hour)!=1) {
			printf("Usage: ./inigenerator year month day hour\n");
			return 1;
		}
	}
	else {
		printf("Usage: ./inigenerator year month day hour\n");
		return 1;
	}
	double jd = julian_date(year,month,day,hour);

	// Computation of positions and velocies
	short int j,de=406;
	double jd_end = jd+1;
	ephem_open("./ephemeris/JPLEPH",&jd,&jd_end,&de);
	for(i=0;i<3;i++)
		planets_positions_equatorial[0][i]=0;
	for(i=1;i<9;i++) {
		solarsystem(jd,i,1,planets_positions_equatorial[i],planets_velocities_equatorial[i]);
		for(j=0;j<3;j++) {
			planets_positions_equatorial[i][j]*=149597870700;
			planets_velocities_equatorial[i][j]*=149597870700/(24*3600);
		}
	}			

	// Conversion equatorial -> ecliptic coordinates
	double obliquity,tobl,ee,dpsi,deps;
	e_tilt(jd, 0, &obliquity, &tobl, &ee, &dpsi, &deps);
	obliquity *= PI/180;
	double rotation[3][3] =
	{{1		,0		,0		}
	,{0		,cos(obliquity)	,sin(obliquity)	}
	,{0		,-sin(obliquity),cos(obliquity)	}};
	int k;
	for(i=0; i<9; i++) {
		for(j=0; j<3; j++) {
			planets_positions_ecliptic[i][j] = 0.0;
			planets_velocities_ecliptic[i][j] = 0.0;
			for(k=0; k<3; k++) {
				planets_positions_ecliptic[i][j]+=rotation[j][k]*planets_positions_equatorial[i][k];
				planets_velocities_ecliptic[i][j]+=rotation[j][k]*planets_velocities_equatorial[i][k];
			}
		}
	}
	ephem_close();

	//Saving of data in solarsystem.ini
	FILE* out=NULL;
	out=fopen("solarsystem.ini","w+");
	for(i=0;i<9;i++) {
		fprintf(out,"[%s]\n",planets_names[i]);
		fprintf(out,"mass = %e\n",planets_masses[i]);
		fprintf(out,"x_0 = %e\n",planets_positions_ecliptic[i][0]);
		fprintf(out,"x_1 = %e\n",planets_positions_ecliptic[i][1]);
		fprintf(out,"x_2 = %e\n",planets_positions_ecliptic[i][2]);
		fprintf(out,"v_0 = %e\n",planets_velocities_ecliptic[i][0]);
		fprintf(out,"v_1 = %e\n",planets_velocities_ecliptic[i][1]);
		fprintf(out,"v_2 = %e\n\n",planets_velocities_ecliptic[i][2]);
	}
	return 0;
}
