#!/usr/bin/perl -w

use strict;

my ($l_sun,$l_mercury);
my ($x_sun,$y_sun,$z_sun);
my ($x_mercury,$y_mercury,$z_mercury);
my ($x_abs,$y_abs,$z_abs);

open(I_mercury,"<","solsys-Mercury") or die("open(solsys-Mercury): $!");
open(I_sun,"<","solsys-Sun") or die("open(solsys-Sun): $!");
open(O,">","abs-Mercury") or die("open(abs-Mercury): $!");

if( defined($l_sun=<I_sun>) && defined($l_mercury=<I_mercury>) ) {
	print O "$l_sun\n";
}
while( defined($l_sun=<I_sun>) && defined($l_mercury=<I_mercury>) ) {
	chomp $l_mercury;
	chomp $l_sun;
	if( ( ($x_sun,$y_sun,$z_sun) = ($l_sun=~m/([-+]*\d+\.\d+)\t([-+]*\d+\.\d+)\t([-+]*\d+\.\d+)\t/) ) &&
	    ( ($x_mercury,$y_mercury,$z_mercury) = ($l_mercury=~m/([-+]*\d+\.\d+)\t([-+]*\d+\.\d+)\t([-+]*\d+\.\d+)\t/) ) ) {
		$x_abs = $x_mercury - $x_sun;
		$y_abs = $y_mercury - $y_sun;
		$z_abs = $z_mercury - $z_sun;
		print O "$x_abs\t$y_abs\t$z_abs\n";
	}
}
