clear all;

step = 5000;

coord = load('abs-Mercury');
x = coord(:,1);
y = coord(:,2);
z = coord(:,3);
r = x.^2+y.^2+z.^2;
index_max = size(x,1);

size_window = ceil(44*24*3600/step);
size_interp = ceil(30000/step);

nmin = 1;
nmax = nmin+size_window*2;
previous_i_max = 0;
count_max = 0;
while(nmax<index_max)
	[r_max, i_max] = max(r(nmin:nmax));
	i_max += nmin-1;
	if(i_max!=nmin && i_max!=nmax && i_max!=previous_i_max)
		previous_i_max = i_max;
		count_max++;

		nmin_interp = max(i_max-size_interp,1);
		nmax_interp = min(i_max+size_interp,index_max);

		pol = polyfit( transpose(nmin_interp:nmax_interp) , r(nmin_interp:nmax_interp) , 2 );
		np = -pol(2)/(2*pol(1));
		
		xp = interp1(x,np,'linear');
		yp = interp1(y,np,'linear');
		zp = interp1(z,np,'linear');

		perihelion(count_max,1) = np*step/(365*24*3600);
		perihelion(count_max,2) = sqrt(xp^2+yp^2+zp^2);
		perihelion(count_max,3) = acos(zp/perihelion(count_max,2));
		perihelion(count_max,4) = acos(xp/sqrt(xp^2+yp^2));
	endif
	nmin += size_window;
	nmax += size_window;
endwhile
save('perihelion_fine','perihelion');
