#ifndef COMMON_TYPES_H
#define COMMON_TYPES_H

#define NB_COMPUTS 3
#define SQ(x) ((x)*(x))
/** @file
 * Declarations used by external files that defines numerical methods.
 */

/**
 * A computation function.
 *
 * General type used by functions that computes position, velocity, and
 * acceleration.
 */
typedef int (*cel_compute) (cel_system *, int);

/**
 * Numerical method.
 *
 * You must export your methods with this structure, as a global variable.
 * The global variable must be added in the array compute_methods.
 * The name must be also put in the enum method_names.
 */
typedef struct {
	char** name; /**< Name of the method. Used in print_usage.*/
	char** cl_switch; /**< Switch used in command line. */
	
	/**
	 * Pointers to functions needed by the method.
	 *
	 * Expect 3 functions :
	 * - position
	 * - velocity
	 * - acceleration
	 * The order is the order of computations, allowing calculus which are
	 * dependants of the others.
	 * Generally, compute_a should be choosen for the acceleration.
	 */
	cel_compute compute[NB_COMPUTS];
	
	int nb_submethods;
} compute_method ;



int compute_a(cel_system *sys, int submethod);
int compute_and_print(cel_system *sys, cel_files *files,
		int method, int submethod, int ref_type);
#endif // COMMON_TYPES_H
