#ifndef COMMON_EXT_H
#define COMMON_EXT_H
#include "common.h"

/** @file
 * Declarations used by external files, except ones that define a numerical
 * method.
 */

/*
 * Variable name of the method should appear there.
 */
extern compute_method velocity_verlet;
extern compute_method euler;
extern compute_method symplectic_euler;
extern compute_method explicit_rk;

/**
 * Contains methods name.
 * Actually, you can name your method as you want in this enum.
 * The first name is default.
 * You should add your method before NB_METHODS.
 */
enum method_names { VELOCITY_VERLET, EULER, SYMPLECTIC_EULER, EXPLICIT_RK, NB_METHODS };

/**
 * Array of compute_method structures.
 * You should add a pointer to your method there.
 * The order must be the same as method_names.
 */
static compute_method *compute_methods[NB_METHODS] = {
	&velocity_verlet, 
	&euler,
	&symplectic_euler,
	&explicit_rk
};

#endif // COMMON_EXT_H
