#include "euler.h"
#include "celeste_types.h"
#include <math.h>



int compute_x_euler(cel_system *sys, int submethod) {
	planet **planets = sys->planets;
	int i, j;
	double step = sys->time_step;

	for(i=0; i < sys->nb_planets; i++) {
		for(j=0; j < sys->dimension; j++)
			planets[i]->x_next[j] = planets[i]->x_cur[j] 
				+ step*planets[i]->v_cur[j];
	}
	return 0;
}

int compute_v_euler(cel_system *sys, int submethod) {
	planet **planets = sys->planets;
	int i, j;
	double step = sys->time_step;

	for(i=0; i < sys->nb_planets; i++) {
		for(j=0; j < sys->dimension; j++)
			planets[i]->v_next[j] = 
				planets[i]->v_cur[j] + step*planets[i]->a_cur[j];
	}
	return 0;
}
	
int compute_v_symplectic_euler(cel_system *sys, int submethod) {
	planet **planets = sys->planets;
	int i, j;
	double step = sys->time_step;
	
	for(i=0; i < sys->nb_planets; i++) {
		for(j=0; j < sys->dimension; j++)
			planets[i]->v_next[j] = 
				planets[i]->v_cur[j] + step*planets[i]->a_next[j];
	}
	return 0;
}

