#ifndef EULER_H
#define EULER_H
#include "celeste_types.h"
#include "common.h"

int compute_x_euler(cel_system *sys, int submethod);
int compute_v_euler(cel_system *sys, int submethod);

int compute_v_symplectic_euler(cel_system *sys, int submethod);

char* euler_name[1] = {"Euler"};
char* euler_cl_switch[1] = {"e"};
const compute_method euler = {
	.name = (char **)euler_name,
	.cl_switch = (char **)euler_cl_switch,
	.nb_submethods = 1,
	.compute = {&compute_x_euler, &compute_v_euler, &compute_a}
};

char* simplectic_euler_name[1] = {"Simplectic Euler"};
char* simplectic_euler_cl_switch[1] = {"s"};
const compute_method symplectic_euler = {
	.name = (char **)simplectic_euler_name,
	.cl_switch = (char **)simplectic_euler_cl_switch,
	.nb_submethods = 1,
	.compute = {&compute_x_euler, &compute_a, &compute_v_symplectic_euler}
};
#endif // EULER_H
