#ifndef EXPLICIT_RK_H
#define EXPLICIT_RK_H
#include "celeste_types.h"
#include "rk_matrices.h"
#include "common.h"

/**
 * General definitions for the explicit Runge-Kutta method
 */
int compute_x_and_v_explicit_rk(cel_system *sys, int submethod);
int compute_nothing_explicit_rk(cel_system *sys, int submethod); //An artefact: we can't separate the global calculus of x and v


char* rk_name[5] = {
	"Runge method of order 2",
	"Hun method of order 3",
	"Kutta method of order 4",
	"Nyström method of order 5",
	"Butcher method of order 6"};
char* rk_cl_switch[5] = {
	"rk2",
	"rk3",
	"rk4",
	"rk5",
	"rk6"};
const compute_method explicit_rk = {
	.name = (char **)rk_name,
	.cl_switch = (char **)rk_cl_switch,
	.nb_submethods = NB_RK_SUBMETHODS,
	.compute = {&compute_x_and_v_explicit_rk, &compute_nothing_explicit_rk, &compute_a}
};

/**
 * Function for the intermediate steps: 
 * dy/dt=FG/h (h is the step) and y=(x,v)
 */
void compute_K_explicit_rk(double **K_pos, double **K_vel, double **pos, double **vel, cel_system *sys);

/**
 * Functions to allocate and free memory for Runge-Kutta matrices
 */
void alloc_rk_matrices(double ****K_pos, double ****K_vel, double ****pos, double ****vel, int nb_stages, cel_system *sys);
void free_rk_matrices(double ****K_pos, double ****K_vel, double ****pos, double ****vel, int nb_stages, cel_system *sys);

#endif // EXPLICIT_RK_H
