/* @file
 * Minimalistic implementation of some generic data structures.
 *
 * Implemented data structures:
 * - Singly-linked list (slist)
 */


#include <string.h>
#include <stdlib.h>
#include "mylib.h"

// Singly-linked lists :
slist *slist_new (void) {
	slist *l = malloc(sizeof(slist));
	l->first = NULL;
	l->cur = NULL;
	return l;
}

void slist_push (slist* l, void *data) {
	slist_node *n = malloc(sizeof(slist_node));
	n->next = l->first;
	n->data = data;
	l->first = n;
	return;
}

void *slist_pop(slist* l) {
	slist_node *n; void* data;
	if(l->first == NULL)
		return NULL;
	n = l->first;
	l->first = n->next;
	data = n->data;
	free(n);
	return data;
}

void slist_rem_node(slist* l, void (*free_data) (void*)) {
	void *data = slist_pop(l);
	if(free_data == NULL)
		return;
	(*free_data)(data);
	return;
}

void slist_free(slist* l, void (*free_data) (void*)) {
	while(l->first != NULL)
		slist_rem_node(l, free_data);
	return;
}

int slist_length(slist* l) {
	slist_node *n;
	int len = 0;
	n = l->first;
	while(n != NULL) {
		len++;
		n = n->next;
	}
	return len;
}

void slist_rewind(slist *l) {
	l->cur = l->first;
	return;
}

void *slist_cur(slist *l) {
	if(l->cur == NULL)
		return NULL;
	return l->cur->data;
}

int slist_next(slist *l) {
	if(l->cur == NULL)
		return 1;
	l->cur = l->cur->next;
	if(l->cur == NULL)
		return 1;
	else
		return 0;
}

