#ifndef MYLIB_H
#define MYLIB_H

// Singly-linked lists :
typedef void (*slist_destruct_data) (void *);

typedef struct slist_node {
	void *data;
	struct slist_node *next;
}slist_node;

typedef struct slist {
	slist_node *first;
	slist_node *cur;
}slist;

slist *slist_new(void);
void slist_push(slist *l, void * data);
void *slist_pop(slist *l);
void slist_rem_node(slist *l, void (*data)(void*));
void slist_free(slist *l, void(*data)(void*));
void slist_rewind(slist *l);
void *slist_cur(slist *l);
int slist_next(slist *l);
int slist_length(slist *l);

#endif // MYLIB_H
