%{
#include "parsertypes.h"
#include "mylib.h"
#include <stdlib.h>
#include "parser.tab.h"
%}
%option noyywrap



WS		[ \t]+
INT		[0-9]+
SIGINT	[+-]?{INT}
EXP		[eE]{SIGINT}
DBL		(({SIGINT}\.{INT}?|[+-]?\.{INT}){EXP}?|{SIGINT}{EXP}?)
STRING	[a-zA-Z0-9]+



%%

^{WS}?;.*\n	{ /* ignore comments line */ }
;.*$		{ /* ignore comments */ }
{WS}		{ /* ignore whitespaces */ }
^{WS}?\n	{ /* ignore empty lines */ }
{INT}		{ yylval.ival = atoi(yytext); return INT; }
{DBL}		{ yylval.dval = strtod(yytext, NULL); return DBL; }
{STRING}	{ yylval.str = strdup(yytext); return STRING; }
"="			{ return EQ; }
"["			{ return BRA; }
"]"			{ return KET; }
"\n"		{ return NEWLINE; }
"_"			{ return UNDERSCORE; }

%%
