#include <stdlib.h>
#include "parsertypes.h"


key *key_new(void) {
	key *k = malloc(sizeof(key));
	k->name = NULL;
	k->subscript = -1;
	return k;
}

void key_free(key *k) {
	free(k->name);
	free(k);
	return;
}

section *section_new(void) {
	section *sec = malloc(sizeof(section));
	sec->head = NULL;
	sec->keys = NULL;
	return sec;
}

void section_free(section *sec) {
	slist_free(sec->keys, (slist_destruct_data) key_free);
	free(sec->head);
	free(sec);
}
