/** @file
 * Defines types for the generic part that parses .ini in parser.y.
 */
#ifndef PARSER_H
#define PARSER_H
#include "mylib.h"

/**
 * Stores a key of the form:
 * x_42 = 1337
 * where:
 * - x is the name.
 * - 42 is the optionnal subscript (equals -1 when not precised).
 * - 1337 is the value.
 */
typedef struct key {
	char *name;
	int subscript;
	double val;
}key;

key *key_new(void);
void key_free(key *k);

/**
 * Stores a section of the form :
 * [head]
 * keys
 */
typedef struct section {
	char *head;
	slist *keys;
}section;


section *section_new(void);
void section_free(section *sec);


#endif // PARSER_H
