#ifndef RK_MATRICES_H
#define RK_MATRICES_H

#include <stdlib.h>
#include <math.h>

/*
 * Definition of the 2nd order Runge Kutta matrix (Runge, 1885)
 */
static double rk2[3][2] = 	
{{0	,0	}
,{1./2	,0	}
,{0	,1.	}};


/*
 * Definition of a 3nd order Runge Kutta matrix (Hun, 1900)
 */
double rk3[4][3] =
{{0	,0	,0	}
,{1./3	,0	,0	}
,{0	,2./3	,0	}
,{1./4	,0	,3./4	}};


/*
 * Definition of the 4th order Runge Kutta matrix (Kutta, 1901)
 */
double rk4[5][4] =
{{0	,0	,0	,0	}
,{1./2	,0	,0	,0	}
,{0	,1./2	,0	,0	}
,{0	,0	,1.	,0	}
,{1./6	,1./3	,1./3	,1./6	}};


/*
 * Definition of a 5th order Runge-Kutta matrix (Kutta, 1901, corrected by Nystrom, 1925)
 */
double rk5[7][6] =
{{0	,0	,0	,0	,0	,0	}
,{1./3	,0	,0	,0	,0	,0	}
,{4./25	,6./25	,0	,0	,0	,0	}
,{1./4	,-3.	,15./4	,0	,0	,0	}
,{2./27	,10./9	,-50./81,8./81	,0	,0	}
,{2./25	,12./25	,2./15	,8./75	,0	,0	}
,{23./192,0	,125./192,0	,-27./64,125./192}};



/*
 * Definition of a 6th order Runge-Kutta matrix (Butcher, 1964)
 */
double rk6[8][7] =
{{0     ,0      ,0      ,0      ,0      ,0      ,0	}
,{1./3	,0	,0	,0	,0	,0	,0	}
,{0	,2./3	,0	,0	,0	,0	,0	}
,{1./12	,1./3	,-1./12	,0	,0	,0	,0	}
,{-1./16,9./8	,-3./16	,-3./8	,0	,0	,0	}
,{0	,9./8	,-3./8	,-3./4	,1./2	,0	,0	}
,{9./44	,-9./11	,63./44	,18./11	,0	,-16./11,0	}
,{11./120,0	,27./40	,27./40	,-4./15	,-4./15	,11./120}};



/*
 * Definition of the array of Runge-Kutta matrices
 */
enum rk_names { RK2 , RK3 , RK4 , RK5 , RK6 , NB_RK_SUBMETHODS };

typedef struct {
	double* A;
	int nb_stages;
} rk_matrix ;

static rk_matrix rk[NB_RK_SUBMETHODS] =
{{ .A = (double*) rk2 , .nb_stages = 2 }
,{ .A = (double*) rk3 , .nb_stages = 3 }
,{ .A = (double*) rk4 , .nb_stages = 4 }
,{ .A = (double*) rk5 , .nb_stages = 6 }
,{ .A = (double*) rk6 , .nb_stages = 7 }};

#endif
