#include "velocity_verlet.h"


int compute_x_velocity_verlet(cel_system *sys, int submethod) {
	int i, j;
	double step = sys->time_step;
	planet **planets = sys->planets;

	for(i=0; i < sys->nb_planets; i++) {
		for(j=0; j < sys->dimension; j++) 
			planets[i]->x_next[j] = planets[i]->x_cur[j] +
				step*planets[i]->v_cur[j] +
				SQ(step)*planets[i]->a_cur[j]/2.0;
	}
	return 0;
}

int compute_v_velocity_verlet(cel_system *sys, int submethod) {
	int i, j;
	double step = sys->time_step;
	planet **planets = sys->planets;


	for(i=0; i < sys->nb_planets; i++) {
		for(j=0; j < sys->dimension; j++)
			planets[i]->v_next[j] = planets[i]->v_cur[j] +
				step/2.0*(planets[i]->a_cur[j] + planets[i]->a_next[j]);
	}
	return 0;
}
