#ifndef VELOCITY_VERLET_H
#define VELOCITY_VERLET_H

#include "celeste_types.h"
#include "common.h"

int compute_x_velocity_verlet(cel_system *sys, int submethod);
int compute_v_velocity_verlet(cel_system *sys, int submethod);
int compute_a_velocity_verlet(cel_system *sys, int submethod);

char* verlet_name[1] = {"Velocity Verlet"};
char* verlet_cl_switch[1] = {"v"};
const compute_method velocity_verlet = {
	.name = (char **)verlet_name,
	.cl_switch = (char **)verlet_cl_switch,
	.nb_submethods = 1,
	.compute = {&compute_x_velocity_verlet, 
		&compute_a, &compute_v_velocity_verlet}
};
#endif // VELOCITY_VERLET_H
