#ifndef GALAXY_TYPES_H
#define GALAXY_TYPES_H

#include "int.h"
enum coord_name {X,Y,Z};

typedef struct {
	uint nb_element;
	uint dimension;

	double duration;
	double stepsize;
	uint nbstep;

	double* vel;
	double* pos;
	double* mass;
} gal_system;

gal_system *alloc_gal_system(uint dimension, uint nb_element,
		double duration, uint nbstep);
int realloc_gal_system(gal_system *sys, uint nb_element);
void free_gal_system(gal_system *sys); 
int create_spherical_galaxy(gal_system *sys, double typical_length,
		double radius_max, double total_mass, uint start_at, uint stop_at);
int create_uniform_gas(gal_system *sys, double typical_velocity,
		double radius, double total_mass, uint start_at, uint stop_at);
int create_particle(gal_system *sys, double *position, double *velocity,
		double mass, uint at);
int add_position(gal_system *sys, double *position, uint start_at, uint stop_at);
int add_velocity(gal_system *sys, double *velocity, uint start_at, uint stop_at);
int add_ang_momentum(gal_system *sys, double max_speed, double typical_radius,
		uint start_at, uint stop_at);
#endif // GALAXY_TYPES_H
