#ifndef GPU_H
#define GPU_H
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gpu_euler.h"
#include "gpu_verlet.h"

#ifdef SPEEDRUN
#include <time.h>
#endif // SPEEDRUN

#ifdef __APPLE__
#include <OpenCL/opencl.h>
#else
#include <CL/cl.h>
#endif

#define MAXDIM 3

/*
 * Abort if there is an error.
 */
#define CL_CHECK(_expr)											\
	do {														\
		cl_int _err = _expr;									\
		if (_err == CL_SUCCESS) 								\
			break;												\
		fprintf(stderr,											\
				"OpenCL Error: " #_expr " returned %d\n",		\
				_err);											\
		abort();												\
	} while(0)


/*
 * This structure regroups a lot of thing that are needed by the various
 * OpenCL functions.
 */
typedef struct {
	cl_uint nb_platform;
	cl_platform_id *platforms;
	cl_uint nb_device;
	cl_device_id *devices;
	cl_context context;
	cl_command_queue command_queue;
	cl_program program;
	size_t max_wg_size;
} cl_host;

cl_host *initialize_gpu(void);
cl_double3 *redim_coords(int dim, int nb_planet, double coords[nb_planet][dim]); 
cl_program buildProgramFromFile(cl_host *host, const char *filename,
		const char *options);
int clReleaseHost(cl_host *host);
size_t optimal_workgroup_size(cl_host *host, uint nb_thread);
size_t optimal_globalwork_size(cl_host *host, uint nb_thread);


#endif /* GPU_H */
