#include <string.h>
#include <stdlib.h>
#include "mylib.h"

// Singly-linked lists :
slist *slist_new (void) {
	slist *l = malloc(sizeof(slist));
	l->first = NULL;
	return l;
}

void slist_push (slist* l, void *data) {
	slist_node *n = malloc(sizeof(slist_node));
	n->next = l->first;
	n->data = data;
	l->first = n;
	return;
}

void *slist_pop(slist* l) {
	slist_node *n; void* data;
	if(l->first == NULL)
		return NULL;
	n = l->first;
	l->first = n->next;
	data = n->data;
	free(n);
	return data;
}

void slist_rem_node(slist* l, void (*free_data) (void*)) {
	void *data = slist_pop(l);
	if(free_data == NULL)
		return;
	(*free_data)(data);
	return;
}

void slist_free(slist* l, void (*free_data) (void*)) {
	while(l->first != NULL)
		slist_rem_node(l, free_data);
	return;
}

int slist_length(slist* l) {
	slist_node *n;
	int len = 0;
	n = l->first;
	while(n != NULL) {
		len++;
		n = n->next;
	}
	return len;
}

// Doubly-linked lists :

dlist *dlist_new(void) {
	dlist *l;
	l = malloc(sizeof(dlist));
	l->first = l->last = l->cur = NULL;
	return l;
}

void dlist_enqueue(dlist *l, void *data) {
	dlist_node *n;
	n = malloc(sizeof(dlist_node));
	n->prev = l->last;
	n->next = NULL;
	n->data = data;
	if(l->last == NULL) { // l is empty
		l->first = n;
		l->last = n;
		return;
	}

	n->prev->next = n;
	l->last = n;
	return;
}

void *dlist_dequeue(dlist *l) {
	dlist_node *n;
	void *data;
	n = l->last;
	if(n == NULL)
		return NULL;
	l->last = n->prev;
	
	data = n->data;
	free(n);

	if(l->last == NULL) {
		l->first = NULL;
		return data;
	}
	l->last->next = NULL;
	return data;
}

void dlist_push(dlist *l, void *data) {
	dlist_node *n;
	n = malloc(sizeof(dlist_node));
	n->next = l->first;
	n->prev = NULL;
	n->data = data;
	
	if(l->first == NULL) { // l is empty
		l->last = n;
		l->first = n;
		return;
	}
	n->next->prev = n;
	l->first = n;
	return;
}

void *dlist_pop(dlist *l) {
	dlist_node *n;
	void *data;
	n = l->first;
	if(n == NULL)
		return NULL;
	l->first = n->next;
	
	data = n->data;
	free(n);

	if(l->first == NULL) {
		l->last = NULL;
		return data;
	}
	
	l->first->prev = NULL;
	return data;
}

void dlist_rewind(dlist *l) {
	l->cur = l->first;
	return;
}

int dlist_next(dlist *l) {
	if(l->cur == NULL)
		return 0;
	l->cur = l->cur->next;
	return 1;
}

int dlist_prev(dlist *l) {
	if(l->cur == NULL || l->cur->prev == NULL)
		return 0;
	l->cur = l->cur->prev;
	return 1;
}

void *dlist_getdata(dlist *l) {
	if(l->cur == NULL)
		return NULL;
	return l->cur->data;
}

void dlist_insertdata(dlist *l, void *data) {
	dlist_node *n;
	
	if(l->cur == NULL)
		return dlist_enqueue(l, data);

	n = malloc(sizeof(dlist_node));
	n->next = l->cur;
	n->prev = l->cur->prev;
	n->prev->next = n;
	n->next->prev = n;
	return;
}

void dlist_delete_node(dlist *l, void (*free_data)(void*)) {
	dlist_node *cur, *next, *prev;

	cur = l->cur;
	if(cur == NULL)
		return;
	if(free_data != NULL)
		(*free_data)(cur->data);
	
	prev = cur->prev;
	next = cur->next;

	if(prev != NULL)
		prev->next = next;
	else
		l->first = next;

	if(next != NULL)
		next->prev = prev;
	else
		l->last = next;

	l->cur = next;

	free(cur);
	return;
}

void dlist_free(dlist *l, void (*free_data)(void*)) {
	dlist_node *n;
	while((n = dlist_pop(l)) != NULL) {
		if(free_data != NULL)
			(*free_data)(n->data);
	}
	free(l);
	return;
}

