#ifndef MYLIB_H
#define MYLIB_H

// Singly-linked lists :
typedef void (*slist_destruct_data) (void *);

typedef struct slist_node {
	void *data;
	struct slist_node *next;
}slist_node;

typedef struct slist {
	slist_node *first;
}slist;

slist *slist_new(void);
void slist_push(slist *l, void * data);
void *slist_pop(slist *l);
void slist_rem_node(slist *l, void (*data)(void*));
void slist_free(slist *l, void(*data)(void*));
int slist_length(slist *l);

// Doubly-linked lists :
typedef struct dlist_node {
	void *data;
	struct dlist_node *next;
	struct dlist_node *prev;
}dlist_node;
typedef struct dlist {
	dlist_node *first;
	dlist_node *last;
	dlist_node *cur;
}dlist;

typedef void (*dlist_destruct_data) (void *);

dlist *dlist_new(void);

void dlist_enqueue(dlist *l, void *data);
void *dlist_dequeue(dlist *l);

void dlist_push(dlist *l, void *data);
void *dlist_pop(dlist *l);

void dlist_rewind(dlist *l);

int dlist_next(dlist *l);
int dlist_prev(dlist *l);

void dlist_insertdata(dlist *l, void *data);
void dlist_delete_node(dlist *l, void (*free_data)(void*));
void dlist_free(dlist *l, void (*free_data)(void*));
#endif // MYLIB_H
