%{
#include "parsertypes.h"
#include "mylib.h"
#include <stdlib.h>
#include "parser.tab.h"
#pragma GCC diagnostic ignored "-Wsign-compare"
%}
%option noyywrap
%option nounput
%option noinput


WS		[ \t]+
STRING	[^\[\]\n= \t]+


%%

^{WS}?;.*\n	{ /* ignore comments line */ }
;.*$		{ /* ignore comments */ }
{WS}		{ /* ignore whitespaces */ }
^{WS}?\n	{ /* ignore empty lines */ }
{STRING}	{ yylval.str = strdup(yytext); return STRING; }
"="			{ return EQ; }
"["			{ return BRA; }
"]"			{ return KET; }
"\n"		{ return NEWLINE; }

%%
