%{
/** @file
 * Parses .ini files.
 * 
 * This lex&yacc-parser is a quite generic parser analyze the .ini grammar. 
 * Each section contains a list of keys and a head. Sections are pushed in
 * a list.
 */

#include <stdlib.h>
#include <math.h>
#include "mylib.h"
#include "parsertypes.h"
#include "parser.h"
#include "yy.lex.h"
#include <stdio.h>
#include <string.h>


int yyerror(const char *p) {
	fprintf(stderr, "%s\n", p);
	exit(EXIT_FAILURE);
}

dlist *file_sections;

%}

%union {
	char	*str;
	key		*key;
	section	*section;
	dlist	*list;
};

%token <str> STRING
%token EQ BRA KET NEWLINE UNDERSCORE
%type <key> KEY
%type <str> HEAD
%type <section> SECTION
%type <list> KEYS SECTIONS
%start input
%%
input	: SECTIONS { file_sections = $1; }
	  	;

SECTIONS: /* empty */ { $$ = dlist_new(); }
		| SECTIONS SECTION { $$ = $1; dlist_enqueue($$, $2);}
		;

SECTION	: HEAD KEYS { $$ = section_new(); $$->head = $1; $$->keys = $2; }
		;

HEAD	: BRA STRING KET NEWLINE { $$ = strdup($2); }
		;

KEYS	: /* empty */ { $$ = dlist_new(); }
		| KEYS KEY { $$ = $1; dlist_enqueue($$, $2); }
		;

KEY		: STRING EQ STRING NEWLINE 
	 		{ $$ = key_new(); $$->name = strdup($1);
			  $$->val = strdup($3); }
		;

%%
/**
 * Parses the INI file and returns a list of key-values.
 */
dlist *parse(FILE *input_file) {
	if(input_file == NULL)
		yyin = stdin;
	else
		yyin = input_file;

	yyparse();
	dlist_rewind(file_sections);
	return file_sections;
}
