/** @file
 * Defines types for the generic part that parses .ini in parser.y.
 */
#ifndef PARSER_TYPES_H
#define PARSER_TYPES_H
#include "mylib.h"

/**
 * Stores a key of the form:
 * x = 1337
 * where:
 * - x is the name.
 * - 1337 is the value.
 */
typedef struct key {
	char *name;
	char *val;
}key;

key *key_new(void);
void key_free(key *k);

/**
 * Stores a section of the form :
 * [head]
 * keys
 */
typedef struct section {
	char *head;
	dlist *keys;
}section;


section *section_new(void);
void section_free(section *sec);


#endif // PARSER_TYPES_H
