#ifndef RANDOM_COORD
#define RANDOM_COORD

#include <stdlib.h>
#include "galaxy_types.h"

static inline double random_plain(double min, double max) {
	return (rand() / (double) RAND_MAX) * (max-min) + min;
}

double random_hernquist_radius(double typical_length, double radius_max);
double random_plain_phi();
double random_plain_theta();

double random_hernquist_velocity_norm(double radius, double typical_length, double total_mass);

double random_boltzmann_norm(double typical_norm);

double random_exponential(double typical_val);

double random_plain_norm(double max_norm);

#endif

