import csv
import bpy
from mathutils import Vector

filedir="/home/benjamin/cours/m1s2/gepuku/galaxy"

zeroes = 6
nbfiles = 600
fact = 1E15

colors = [
#		[155/255,176/255,255/255],
#		[170/255,191/255,255/255],
		[202/255,215/255,255/255],
#		[248/255,247/255,255/255],
#		[255/255,244/255,234/255],
#		[255/255,210/255,161/255],
		[255/255,204/255,111/255]
		]

color_every = [
		0,
		1,
		1,
		1,
		1,
		1,
		1,
		1,
		1,
		1
		]

mat = []
nbcolor = len(colors)
for i in range(0,nbcolor):
	matname = 'star' + str(i)
	if matname in bpy.data.materials:
		mat.append(bpy.data.materials[matname])
	else:
		mat.append(bpy.data.materials.new(matname))
	mat[i].type = 'HALO'
	mat[i].diffuse_color = colors[i]
	mat[i].halo.size = 0.03

bpy.context.scene.world.horizon_color = [0,0.008,0.016]


scene = bpy.context.scene
for frame in range(0,nbfiles):
	fh = open(filedir + '/{0:0{1}d}.dat'.format(frame,zeroes))
	data = list(csv.reader(fh,delimiter="\t"))
	fh.close()
	verts = []
	edges = []
	faces = []
	objs = []
	meshes = []
	color = 0
	for color in range(0,len(color_every)):
		verts.append([])
	for d in data:
		color = (color+1)%len(color_every)
		vert = [float(d[0])/fact,float(d[1])/fact,float(d[2])/fact]
		verts[color_every[color]].append(vert)
	
	for color in range(0,nbcolor):
		meshes.append(bpy.data.meshes.new('star' + 
			'{0:0{1}d}'.format(frame,zeroes) + '.' + str(color)))
		meshes[color].from_pydata(verts[color], edges, faces)
		obj = bpy.data.objects.new('star' + '{0:0{1}d}'.format(frame,zeroes)
				+ str(color),meshes[color])
		scene.objects.link(obj)
		obj.data.materials.append(mat[color])
		obj.hide = True
		obj.hide_render = True
		obj.keyframe_insert(data_path="hide", frame=1)
		obj.keyframe_insert(data_path="hide_render", frame=1)
		obj.hide = False
		obj.hide_render = False
		obj.keyframe_insert(data_path="hide", frame=frame+1)
		obj.keyframe_insert(data_path="hide_render", frame=frame+1)
		obj.hide = True
		obj.hide_render = True
		obj.keyframe_insert(data_path="hide", frame=frame+2)
		obj.keyframe_insert(data_path="hide_render", frame=frame+2)


scene.update()

#for frame in range(0,nbfiles):
#	fh = open(filedir + '/{0:0{1}d}.dat'.format(frame,zeroes))
#	data = list(csv.reader(fh,delimiter="\t"))
#	fh.close()
#	for star in range(0,len(data)):
#		for i in range(0,3):
#			objs[star].location[i] = float(data[star][i])/1E19
#			objs[star].keyframe_insert(data_path="location",frame=frame,index=i)
